/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.validation;

import java.util.ArrayList;
import net.ionite.docval.validation.ValidationResultItem;
import net.ionite.docval.validation.ValidatorException;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sapling.SaplingDocument;
import net.sf.saxon.sapling.SaplingElement;
import net.sf.saxon.sapling.SaplingNode;
import net.sf.saxon.sapling.Saplings;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ValidationResult {
    private ArrayList<ValidationResultItem> errors = new ArrayList();
    private ArrayList<ValidationResultItem> warnings = new ArrayList();

    public int errorCount() {
        return this.errors.size();
    }

    public int warningCount() {
        return this.warnings.size();
    }

    public void addError(String message, String location, Integer line, Integer column, String test) {
        this.errors.add(new ValidationResultItem(message, location, line, column, test));
    }

    public void addWarning(String message, String location, Integer line, Integer column, String test) {
        this.warnings.add(new ValidationResultItem(message, location, line, column, test));
    }

    public ArrayList<ValidationResultItem> getErrors() {
        return this.errors;
    }

    public ArrayList<ValidationResultItem> getWarnings() {
        return this.warnings;
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put((Object)"error_count", (Object)this.errorCount());
        result.put((Object)"warning_count", (Object)this.warningCount());
        JSONArray errorList = new JSONArray();
        for (ValidationResultItem item : this.errors) {
            errorList.add((Object)item.toJSON());
        }
        result.put((Object)"errors", (Object)errorList);
        JSONArray warningList = new JSONArray();
        for (ValidationResultItem item : this.warnings) {
            warningList.add((Object)item.toJSON());
        }
        result.put((Object)"warnings", (Object)warningList);
        return result;
    }

    public static ValidationResult fromJSON(JSONObject jsonData) throws ValidatorException {
        ValidationResult result = new ValidationResult();
        JSONArray jsonErrors = (JSONArray)jsonData.get((Object)"errors");
        if (jsonErrors == null) {
            throw new ValidatorException("no 'errors' field in JSON data");
        }
        for (JSONObject err : jsonErrors) {
            Long lineLong = (Long)err.get((Object)"line");
            Long columnLong = (Long)err.get((Object)"column");
            result.addError((String)err.get((Object)"message"), (String)err.get((Object)"location"), lineLong != null ? Integer.valueOf(lineLong.intValue()) : null, columnLong != null ? Integer.valueOf(columnLong.intValue()) : null, (String)err.get((Object)"test"));
        }
        JSONArray jsonWarnings = (JSONArray)jsonData.get((Object)"warnings");
        if (jsonWarnings == null) {
            throw new ValidatorException("no 'errors' field in JSON data");
        }
        for (JSONObject err : jsonWarnings) {
            result.addWarning((String)err.get((Object)"message"), (String)err.get((Object)"location"), (Integer)err.get((Object)"line"), (Integer)err.get((Object)"column"), (String)err.get((Object)"test"));
        }
        return result;
    }

    public static ValidationResult fromJSONString(String jsonString) throws ValidatorException {
        try {
            return ValidationResult.fromJSON((JSONObject)new JSONParser().parse(jsonString));
        }
        catch (ParseException e) {
            throw new ValidatorException("JSON parse error: " + e.getMessage(), e);
        }
    }

    public String toJSONString() {
        return this.toJSON().toString();
    }

    private SaplingElement createErrorWarningXMLElement(String tag, ValidationResultItem item) {
        SaplingElement errorElement = Saplings.elem((String)tag).withChild(new SaplingNode[]{Saplings.elem((String)"Message").withText(item.message)}).withChild(new SaplingNode[]{Saplings.elem((String)"Test").withText(item.test)});
        if (item.location != null) {
            errorElement = errorElement.withChild(new SaplingNode[]{Saplings.elem((String)"Location").withText(item.location)});
        }
        if (item.line != null) {
            errorElement = errorElement.withChild(new SaplingNode[]{Saplings.elem((String)"Line").withText(item.line.toString())});
        }
        if (item.column != null) {
            errorElement = errorElement.withChild(new SaplingNode[]{Saplings.elem((String)"Column").withText(item.column.toString())});
        }
        return errorElement;
    }

    public String toXMLString() throws SaxonApiException {
        SaplingElement root = Saplings.elem((String)"ValidationResult").withChild(new SaplingNode[]{Saplings.elem((String)"ErrorCount").withText(Integer.valueOf(this.errorCount()).toString())}).withChild(new SaplingNode[]{Saplings.elem((String)"WarningCount").withText(Integer.valueOf(this.warningCount()).toString())});
        if (this.errorCount() > 0) {
            SaplingElement errorsElement = Saplings.elem((String)"Errors");
            for (ValidationResultItem item : this.errors) {
                errorsElement = errorsElement.withChild(new SaplingNode[]{this.createErrorWarningXMLElement("Error", item)});
            }
            root = root.withChild(new SaplingNode[]{errorsElement});
        }
        if (this.warningCount() > 0) {
            SaplingElement warningsElement = Saplings.elem((String)"Warnings");
            for (ValidationResultItem item : this.warnings) {
                warningsElement = warningsElement.withChild(new SaplingNode[]{this.createErrorWarningXMLElement("Warning", item)});
            }
            root = root.withChild(new SaplingNode[]{warningsElement});
        }
        SaplingDocument doc = Saplings.doc().withChild(new SaplingNode[]{root});
        Processor processor = new Processor(false);
        Serializer serializer = processor.newSerializer();
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "no");
        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        XdmNode xdmNode = doc.toXdmNode(processor);
        String result = serializer.serializeNodeToString(xdmNode);
        return result;
    }
}

