/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.File;
import java.io.IOException;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.server.DocValHttpServer;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class DocValHttpServerMain {
    public static void main(String[] argv) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"ion-docval-server").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        parser.addArgument(new String[]{"-c", "--config"}).help("Use configuration file with schema/schematron definitions");
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        parser.addArgument(new String[]{"-V", "--version"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print the software version and exit");
        try {
            Namespace args = parser.parseArgs(argv);
            if (((Boolean)args.get("version")).booleanValue()) {
                System.out.println(DocValHttpServerMain.class.getPackage().getImplementationVersion());
                System.exit(0);
            }
            if (((Boolean)args.get("verbose")).booleanValue()) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
            } else {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
            }
            Logger logger = LoggerFactory.getLogger((String)DocValHttpServer.class.getName());
            try {
                String path;
                String configFile = (String)args.get("config");
                if (configFile == null) {
                    path = System.getProperty("user.home") + "/.config/ion-docval.conf";
                    logger.debug("Try configuration file path: " + path);
                    if (new File(path).exists()) {
                        configFile = path;
                    }
                }
                if (configFile == null) {
                    path = "/etc/ion-docval.conf";
                    logger.debug("Try configuration file path: " + path);
                    if (new File(path).exists()) {
                        configFile = path;
                    }
                }
                if (configFile == null) {
                    path = System.getProperty("user.dir") + "/ion-docval.conf";
                    logger.debug("Try configuration file path: " + path);
                    if (new File(path).exists()) {
                        configFile = path;
                    }
                }
                if (configFile == null) {
                    System.err.println("No configuration file found and no file provided, aborting.");
                    System.exit(-1);
                }
                try {
                    logger.debug("Using configuration file: " + configFile);
                    DocValHttpServer server = new DocValHttpServer(configFile);
                    Signal.handle(new Signal("HUP"), signal -> {
                        try {
                            System.out.println(signal.getName() + " (" + signal.getNumber() + ")");
                            server.loadConfigFile();
                        }
                        catch (Exception exc) {
                            System.err.println("Error reloading configuration file. Not updating configuration");
                            exc.printStackTrace();
                        }
                    });
                    server.start();
                    Thread.currentThread().join();
                    System.exit(0);
                }
                catch (ConfigurationError configError) {
                    System.out.println(configError.getMessage());
                    System.exit(-2);
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    System.exit(-3);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (ArgumentParserException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
    }
}

