/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.validation.validator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.ionite.docval.validation.ValidationResult;
import net.ionite.docval.validation.ValidatorException;
import net.ionite.docval.validation.validator.DocumentValidator;
import net.ionite.docval.xml.IgnoreErrorHandler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XSLTValidator
implements DocumentValidator {
    protected String _filename;
    protected InputStream _stream;
    private Transformer transformer = null;
    protected Logger logger;

    public XSLTValidator(String filename) {
        this._filename = filename;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.reload();
    }

    public XSLTValidator(InputStream stream) {
        this._stream = stream;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.reload();
    }

    @Override
    public void reload() {
        if (this._filename == null && this.transformer != null) {
            throw new ValidatorException("Can't reload an XSLT validator based on a stream");
        }
        if (this._filename != null) {
            if (this.transformer == null) {
                this.logger.debug("Loading {}", (Object)this._filename);
            } else {
                this.logger.info("Reloading {}", (Object)this._filename);
            }
        } else {
            this.logger.info("Loading XSLT validator from stream");
        }
        this.transformer = this.setupTransformer();
    }

    @Override
    public ValidationResult validate(byte[] source) throws ValidatorException {
        ValidationResult result = new ValidationResult();
        return this.validate(source, result);
    }

    @Override
    public ValidationResult validate(byte[] source, ValidationResult result) throws ValidatorException {
        try {
            SAXResult parseResult = new SAXResult(new SVRLHandler(result));
            this.transformer.transform(new StreamSource(new ByteArrayInputStream(source)), parseResult);
        }
        catch (ValidationException valError) {
            result.addError("Error during schematron validation: " + valError.getMessage(), "Schematron validation", null, null, null);
        }
        catch (TransformerException tfError) {
            for (Throwable t = tfError; t != null; t = ((Throwable)t).getCause()) {
                if (t instanceof SAXParseException) {
                    SAXParseException s = (SAXParseException)t;
                    result.addError(t.getMessage(), "XML Parsing", s.getLineNumber(), s.getColumnNumber(), null);
                    return result;
                }
                if (!(t instanceof XPathException)) continue;
                result.addError(t.getMessage(), "XPath error", null, null, null);
                return result;
            }
            this.logger.error("Validation against SVRL Stylesheet failed", (Throwable)tfError);
            tfError.printStackTrace();
            throw new ValidatorException("Error performing XSLT transformation" + tfError.toString(), tfError);
        }
        return result;
    }

    protected Transformer setupTransformer() {
        try {
            byte[] fileData = this._filename != null ? Files.readAllBytes(Paths.get(this._filename, new String[0])) : this._stream.readAllBytes();
            return this.loadTransformer(new ByteArrayInputStream(fileData));
        }
        catch (IOException error) {
            this.logger.error("Failed to set up XSLT transformer", (Throwable)error);
            throw new ValidatorException("Error setting up XSLT transformer validator for " + this._filename, error);
        }
    }

    protected Transformer loadTransformer(InputStream inputStream) {
        try {
            TransformerFactory transformFactory = TransformerFactory.newInstance();
            transformFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            SAXParserFactory checkFactory = SAXParserFactory.newInstance();
            checkFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            checkFactory.setNamespaceAware(true);
            SAXParser parser = checkFactory.newSAXParser();
            SVRLCheckHandler svrlCheckHandler = new SVRLCheckHandler();
            inputStream.mark(Integer.MAX_VALUE);
            parser.parse(inputStream, (DefaultHandler)svrlCheckHandler);
            if (!svrlCheckHandler.isSVRLStylesheet()) {
                throw new ValidatorException("Stylesheet does not appear to be SVRL Stylesheet: " + this._filename);
            }
            inputStream.reset();
            Transformer transformer = transformFactory.newTransformer(new StreamSource(inputStream));
            transformer.setParameter("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformer.setErrorListener(new IgnoreErrorHandler());
            return transformer;
        }
        catch (IOException | ParserConfigurationException | TransformerConfigurationException | SAXException error) {
            this.logger.error("Failed to load XSLT transformer", (Throwable)error);
            throw new ValidatorException("Error setting up XSLT transformer validator for " + this._filename, error);
        }
    }

    private class SVRLHandler
    extends DefaultHandler {
        private ValidationResult _result;
        private boolean _inFailedAssert;
        private String _flag;
        private String _location;
        private String _test;
        private StringBuilder _currentValue = new StringBuilder();
        private HashMap<String, String> _nsPrefixes = new HashMap();

        public SVRLHandler(ValidationResult result) {
            this._result = result;
            this._inFailedAssert = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this._inFailedAssert) {
                this._currentValue.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (uri.equals("http://purl.oclc.org/dsdl/svrl") && localName.equals("ns-prefix-in-attribute-values")) {
                this._nsPrefixes.put(attributes.getValue("uri"), attributes.getValue("prefix"));
            }
            if (qName.equals("svrl:failed-assert")) {
                this._flag = attributes.getValue("flag");
                this._location = this.applyPrefixes(attributes.getValue("location"));
                this._test = attributes.getValue("test");
            }
            if (qName.equals("svrl:text")) {
                this._inFailedAssert = true;
                this._currentValue.setLength(0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equalsIgnoreCase("svrl:text")) {
                this._inFailedAssert = false;
            }
            if (qName.equalsIgnoreCase("svrl:failed-assert")) {
                if ("warning".equals(this._flag)) {
                    this._result.addWarning(this._currentValue.toString(), this._location, null, null, this._test);
                } else {
                    this._result.addError(this._currentValue.toString(), this._location, null, null, this._test);
                }
            }
        }

        private String applyPrefixes(String input) {
            Pattern pattern = Pattern.compile("(.*/)\\*(:.*)\\[namespace-uri\\(\\)=\\'(.*)\\'\\](.*)", 2);
            Matcher matcher = pattern.matcher(input);
            while (matcher.matches()) {
                String uri = matcher.group(3);
                if (this._nsPrefixes.containsKey(uri)) {
                    input = matcher.group(1) + this._nsPrefixes.get(uri) + matcher.group(2) + matcher.group(4);
                    matcher = pattern.matcher(input);
                    continue;
                }
                return input;
            }
            return input;
        }
    }

    private class SVRLCheckHandler
    extends DefaultHandler {
        private boolean hasSVRLOutput = false;

        private SVRLCheckHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (uri.equals("http://purl.oclc.org/dsdl/svrl")) {
                this.hasSVRLOutput = true;
            }
        }

        public boolean isSVRLStylesheet() {
            return this.hasSVRLOutput;
        }
    }
}

