/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.server.DocValHttpServer;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class DocValHttpServerMain {
    public static void main(String[] argv) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"ion-docval-server").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        parser.addArgument(new String[]{"-c", "--config"}).help("Use configuration file with schema/schematron definitions");
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        parser.addArgument(new String[]{"-V", "--version"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print the software version and exit");
        try {
            Namespace args = parser.parseArgs(argv);
            if (((Boolean)args.get("version")).booleanValue()) {
                System.out.println(DocValHttpServerMain.class.getPackage().getImplementationVersion());
                System.exit(0);
            }
            if (((Boolean)args.get("verbose")).booleanValue()) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
            } else {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "INFO");
            }
            Logger logger = LoggerFactory.getLogger((String)DocValHttpServer.class.getName());
            try {
                String configFile = (String)args.get("config");
                List<String> paths = List.of(System.getProperty("user.home") + "/.config/ion-docval.conf", "/etc/ion-docval.conf", System.getProperty("user.dir") + "/ion-docval.conf", System.getProperty("user.dir") + "/../ion-docval.conf");
                for (String path : paths) {
                    logger.debug("Try configuration file path: " + path);
                    if (!new File(path).exists()) continue;
                    logger.debug("Found configuration file, using: " + path);
                    configFile = path;
                    break;
                }
                if (configFile == null) {
                    System.err.println("No configuration file found and no file provided, aborting.");
                    System.err.println("The following configuration files locations were tried:");
                    for (String path : paths) {
                        System.err.println(path);
                    }
                    System.exit(-1);
                }
                try {
                    logger.debug("Using configuration file: " + configFile);
                    DocValHttpServer server = new DocValHttpServer(configFile);
                    try {
                        Signal.handle(new Signal("XHUP"), signal -> {
                            try {
                                System.out.println(signal.getName() + " (" + signal.getNumber() + ")");
                                server.loadConfigFile();
                            }
                            catch (Exception exc) {
                                System.err.println("Error reloading configuration file. Not updating configuration");
                                exc.printStackTrace();
                            }
                        });
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    server.start();
                    Thread.currentThread().join();
                    System.exit(0);
                }
                catch (ConfigurationError configError) {
                    System.out.println(configError.getMessage());
                    System.exit(-2);
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    System.exit(-3);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (ArgumentParserException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
    }
}

