/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.config;

import java.util.ArrayList;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sapling.SaplingDocument;
import net.sf.saxon.sapling.SaplingElement;
import net.sf.saxon.sapling.SaplingNode;
import net.sf.saxon.sapling.Saplings;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConfigData {
    public boolean autoReload = false;
    public UnknownKeywords unknownKeywords = UnknownKeywords.FAIL;
    public boolean lazyLoad = false;
    public Server server;
    public ArrayList<DocumentType> documentTypes = new ArrayList();

    public JSONObject documentTypesAsJSON() {
        JSONObject result = new JSONObject();
        JSONArray jsonDocumentTypes = new JSONArray();
        for (DocumentType docType : this.documentTypes) {
            jsonDocumentTypes.add((Object)docType.toJSON(false));
        }
        result.put((Object)"document_types", (Object)jsonDocumentTypes);
        return result;
    }

    public String documentTypesAsJSONString() {
        return this.documentTypesAsJSON().toString();
    }

    public String documentTypesAsXMLString() throws SaxonApiException {
        SaplingElement root = Saplings.elem((String)"DocumentTypes");
        for (DocumentType docType : this.documentTypes) {
            root = root.withChild(new SaplingNode[]{docType.toXMLSaplingElement()});
        }
        SaplingDocument doc = Saplings.doc().withChild(new SaplingNode[]{root});
        Processor processor = new Processor(false);
        Serializer serializer = processor.newSerializer();
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "no");
        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        XdmNode xdmNode = doc.toXdmNode(processor);
        String result = serializer.serializeNodeToString(xdmNode);
        return result;
    }

    public static enum UnknownKeywords {
        WARN,
        ERROR,
        FAIL,
        IGNORE;

    }

    public class DocumentType {
        public String name;
        public String description;
        public String keyword;
        public ArrayList<String> validationFiles = new ArrayList();

        public JSONObject toJSON(boolean addValidationFiles) {
            JSONObject result = new JSONObject();
            result.put((Object)"name", (Object)this.name);
            result.put((Object)"description", (Object)this.description);
            result.put((Object)"keyword", (Object)this.keyword);
            if (addValidationFiles) {
                JSONArray jsonValidationFiles = new JSONArray();
                for (String validationFile : this.validationFiles) {
                    jsonValidationFiles.add((Object)validationFile);
                }
                result.put((Object)"validation_files", (Object)jsonValidationFiles);
            }
            return result;
        }

        public String toJSONString(boolean addValidationFiles) {
            return this.toJSON(addValidationFiles).toString();
        }

        public SaplingElement toXMLSaplingElement() {
            SaplingElement element = Saplings.elem((String)"DocumentType").withChild(new SaplingNode[]{Saplings.elem((String)"Name").withText(this.name)});
            if (this.description != null && !"".equals(this.description)) {
                element = element.withChild(new SaplingNode[]{Saplings.elem((String)"Description").withText(this.description)});
            }
            element = element.withChild(new SaplingNode[]{Saplings.elem((String)"Keyword").withText(this.keyword)});
            return element;
        }
    }

    public class Server {
        public ArrayList<Listen> listen = new ArrayList();
    }

    public class Listen {
        public String address;
        public int port;

        public Listen(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }
}

