/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.ionite.docval.validation.ValidatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KeywordDeriver {
    public String deriveKeyword(byte[] source) {
        return this.deriveKeyword(new BufferedInputStream(new ByteArrayInputStream(source)));
    }

    public String deriveKeyword(InputStream source) {
        try {
            SAXParserFactory sfactory = SAXParserFactory.newInstance();
            sfactory.setNamespaceAware(true);
            SAXParser parser = sfactory.newSAXParser();
            DeriverXMLHandler handler = new DeriverXMLHandler();
            parser.parse(source, (DefaultHandler)handler);
            String keyword = handler.getKeyword();
            Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
            logger.debug("Derived keyword for document: " + keyword);
            return keyword;
        }
        catch (IOException tfError) {
            throw new ValidatorException("Error Deriving document keyword: " + tfError.getMessage(), tfError);
        }
        catch (SAXException saxError) {
            throw new ValidatorException("Error Deriving document keyword: " + saxError.getMessage(), saxError);
        }
        catch (ParserConfigurationException pConfError) {
            throw new ValidatorException("Error Deriving document keyword: " + pConfError.getMessage(), pConfError);
        }
    }

    private class DeriverXMLHandler
    extends DefaultHandler {
        private StringBuilder _currentValue = new StringBuilder();
        private String rootElement = null;
        private String namespace = null;
        private String customization = null;
        private String version = null;
        private boolean inCIIDocumentParameter = false;

        private DeriverXMLHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this._currentValue.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this._currentValue.setLength(0);
            if (this.rootElement == null) {
                this.rootElement = localName;
                this.namespace = uri;
            }
            if ("GuidelineSpecifiedDocumentContextParameter".equals(localName)) {
                this.inCIIDocumentParameter = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.customization == null && localName.equals("CustomizationID")) {
                this.customization = this._currentValue.toString();
            } else if (this.customization == null && this.inCIIDocumentParameter && localName.equals("ID")) {
                this.customization = this._currentValue.toString();
            } else if ("GuidelineSpecifiedDocumentContextParameter".equals(localName)) {
                this.inCIIDocumentParameter = false;
            }
        }

        public String getKeyword() {
            if (this.namespace == null || "".equals(this.namespace)) {
                return this.rootElement;
            }
            if (this.customization == null) {
                return this.namespace + "::" + this.rootElement;
            }
            if (this.version == null) {
                if (this.namespace.startsWith("urn:oasis:names:specification:ubl")) {
                    this.version = "2.1";
                } else if (this.namespace.startsWith("urn:un:unece:uncefact:data:standard:CrossIndustryInvoice")) {
                    this.version = "D16B";
                }
            }
            return this.namespace + "::" + this.rootElement + "##" + this.customization + "::" + this.version;
        }
    }
}

