/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.IOException;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.server.DocValHttpServer;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import sun.misc.Signal;

public class DocValHttpServerMain {
    public static void main(String[] argv) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"ion-docval-server").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        parser.addArgument(new String[]{"-c", "--config"}).help("Use configuration file with schema/schematron definitions");
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        try {
            Namespace args = parser.parseArgs(argv);
            if (((Boolean)args.get("verbose")).booleanValue()) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
            } else {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
            }
            try {
                String configFile = (String)args.get("config");
                if (configFile == null) {
                    configFile = System.getProperty("app.home") + "/default_config.xml";
                }
                try {
                    DocValHttpServer server = new DocValHttpServer(configFile);
                    Signal.handle(new Signal("HUP"), signal -> {
                        try {
                            System.out.println(signal.getName() + " (" + signal.getNumber() + ")");
                            server.loadConfigFile();
                        }
                        catch (Exception exc) {
                            System.err.println("Error reloading configuration file. Not updating configuration");
                            exc.printStackTrace();
                        }
                    });
                    server.start();
                    Thread.currentThread().join();
                    System.exit(0);
                }
                catch (ConfigurationError configError) {
                    System.out.println(configError.getMessage());
                    System.exit(-2);
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    System.exit(-3);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (ArgumentParserException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
    }
}

