/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.ionite.docval.server.Client;
import net.ionite.docval.server.DocValClientException;
import net.ionite.docval.validation.ValidationResult;
import net.ionite.docval.validation.ValidationResultItem;
import net.sf.saxon.s9api.SaxonApiException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class ClientMain {
    private static void printResultItem(String itemType, ValidationResultItem item, boolean showDetails) {
        System.out.println(itemType + ": " + item.message);
        if (showDetails) {
            System.out.println("    Test: " + item.test);
            if (item.location != null) {
                System.out.println("    Location: " + item.location);
            }
            if (item.line != null) {
                System.out.println("    Location: " + item.line);
            }
            if (item.column != null) {
                System.out.println("    Location: " + item.column);
            }
            System.out.println("");
        }
    }

    public static void main(String[] argv) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"ion-docval-cli").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        parser.addArgument(new String[]{"-u", "--uri"}).help("Override the default or configured server URI (defaults to http://localhost:35791)").setDefault((Object)"http://localhost:35791");
        parser.addArgument(new String[]{"-o", "--output-format"}).setDefault((Object)"text").help("Set the output format, one of: text (default), details, xml, json, none");
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        parser.addArgument(new String[]{"-V", "--version"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print the software version and exit");
        parser.addArgument(new String[]{"document-file"}).nargs("?").help("XML Document to validate");
        try {
            Namespace args = parser.parseArgs(argv);
            if (((Boolean)args.get("version")).booleanValue()) {
                System.out.println(Client.class.getPackage().getImplementationVersion());
                System.exit(0);
            }
            if (args.get("document_file") == null) {
                System.err.println("Error: missing mandatory document-file argument");
                System.exit(-1);
            }
            if (((Boolean)args.get("verbose")).booleanValue()) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
            } else {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
            }
            Client client = new Client(args.getString("uri"));
            byte[] fileData = Files.readAllBytes(Paths.get(args.getString("document_file"), new String[0]));
            ValidationResult result = client.validate(fileData);
            switch (args.getString("output_format")) {
                case "xml": {
                    try {
                        System.out.println(result.toXMLString());
                    }
                    catch (SaxonApiException saxError) {
                        saxError.printStackTrace();
                        System.out.println("<Error><Detail>Unable to convert validation results to XML</Detail></Error>");
                    }
                    break;
                }
                case "json": {
                    System.out.println(result.toJSONString());
                    break;
                }
                case "text": 
                case "details": {
                    System.out.println("Errors: " + result.errorCount());
                    System.out.println("Warnings: " + result.warningCount());
                    System.out.println("");
                    if (result.errorCount() <= 0 && result.warningCount() <= 0) break;
                    for (ValidationResultItem item : result.getErrors()) {
                        ClientMain.printResultItem("Error", item, args.getString("output_format").equals("details"));
                    }
                    for (ValidationResultItem item : result.getWarnings()) {
                        ClientMain.printResultItem("Warning", item, args.getString("output_format").equals("details"));
                    }
                    System.out.println("");
                    break;
                }
                case "none": {
                    break;
                }
                default: {
                    System.err.println("Unknown output format: " + args.getString("output_format"));
                    System.exit(-1);
                }
            }
            System.exit(result.errorCount());
        }
        catch (ArgumentParserException ape) {
            System.err.println("Error parsing arguments: " + ape.toString());
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.err.println("Error connecting to server: " + ioe.toString());
            System.exit(-2);
        }
        catch (DocValClientException dve) {
            System.err.println("Error validating file: " + dve.toString());
            System.exit(-3);
        }
    }
}

