/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.cli;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.ionite.docval.config.ConfigReader;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.validation.ValidationResult;
import net.ionite.docval.validation.ValidatorException;
import net.ionite.docval.validation.ValidatorManager;
import net.ionite.docval.xml.KeywordDeriver;
import net.sf.saxon.s9api.SaxonApiException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class CommandLineValidator {
    private Namespace args;
    private ArgumentParser parser;

    public CommandLineValidator(String[] argv) {
        this.parseArguments(argv);
    }

    private void parseArguments(String[] argv) {
        this.parser = ArgumentParsers.newFor((String)"ion-docval-cli").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        this.parser.addArgument(new String[]{"-c", "--config"}).help("Use configuration file with schema/schematron definitions");
        this.parser.addArgument(new String[]{"-o", "--output-format"}).help("Output format, one of: text (default), short, none, json, xml");
        this.parser.addArgument(new String[]{"-d", "--derive-keyword"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Do not validate the file, but print the derived keyword");
        this.parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        this.parser.addArgument(new String[]{"-k", "--keyword"}).help("Use the given keyword to select the correct validation when using a config file");
        this.parser.addArgument(new String[]{"-s", "--schemafile"}).action((ArgumentAction)Arguments.append()).help("Validation file XML Schema or Schematron XSLT file. Can be specified multiple times.");
        this.parser.addArgument(new String[]{"document-file"}).help("XML Document to validate");
        try {
            this.args = this.parser.parseArgs(argv);
        }
        catch (ArgumentParserException e) {
            this.parser.handleError(e);
            System.exit(-1);
        }
    }

    public int run() {
        ArrayList sfiles;
        String configFile;
        FileInputStream documentStream;
        if (((Boolean)this.args.get("verbose")).booleanValue()) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
        }
        ValidatorManager validatorManager = new ValidatorManager();
        String documentFile = (String)this.args.get("document_file");
        if (documentFile == null) {
            System.err.println("Missing required argument: -f/--document-file");
            this.parser.printHelp();
            return -1;
        }
        try {
            documentStream = new FileInputStream(documentFile);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe);
            return -1;
        }
        if (this.args.getBoolean("derive_keyword").booleanValue()) {
            KeywordDeriver kwd = new KeywordDeriver();
            System.out.println(kwd.deriveKeyword(documentStream));
            return 0;
        }
        String keyword = (String)this.args.get("keyword");
        if (keyword == null) {
            KeywordDeriver kwd = new KeywordDeriver();
            keyword = kwd.deriveKeyword(documentStream);
        }
        if ((configFile = (String)this.args.get("config")) != null) {
            ConfigReader configReader = new ConfigReader(configFile);
            try {
                validatorManager.applyConfig(configReader.readConfig());
            }
            catch (ConfigurationError configError) {
                System.out.println(configError.getMessage());
                return -2;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                return -3;
            }
        }
        if (((sfiles = (ArrayList)this.args.get("schemafile")) == null || sfiles.size() < 1) && configFile == null) {
            System.err.println("At least one schema/xsl file is required: -s/--schemafile or -c/--config");
            this.parser.printHelp();
            return -1;
        }
        if (sfiles != null) {
            for (String validationFile : sfiles) {
                validatorManager.addValidator(keyword, validationFile, false);
            }
        }
        try {
            ValidationResult result = validatorManager.validate(keyword, Files.readAllBytes(Paths.get(documentFile, new String[0])));
            String of = (String)this.args.get("output_format");
            if (of == null) {
                of = "text";
            }
            switch (of) {
                case "text": {
                    System.out.println("Errors: " + result.errorCount());
                    System.out.println("Warnings: " + result.warningCount());
                    break;
                }
                case "short": {
                    System.out.println("Errors: " + result.errorCount());
                    System.out.println("Warnings: " + result.warningCount());
                    break;
                }
                case "none": {
                    break;
                }
                case "xml": {
                    try {
                        System.out.println(result.toXMLString());
                    }
                    catch (SaxonApiException saxError) {
                        saxError.printStackTrace();
                        System.out.println("<Error><Detail>Unable to convert validation results to XML</Detail></Error>");
                    }
                    break;
                }
                case "json": {
                    System.out.println(result.toJSONString());
                    break;
                }
                default: {
                    System.out.println("Unknown output format: " + this.args.get("output_format"));
                }
            }
            return result.errorCount();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void main(String[] argv) {
        try {
            CommandLineValidator validator = new CommandLineValidator(argv);
            System.exit(validator.run());
        }
        catch (ValidatorException valError) {
            System.err.print("Error: " + valError.toString());
            if (valError.getCause() != null) {
                Throwable root = valError;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                System.err.println(": " + root.toString());
            } else {
                System.err.println();
            }
            System.exit(-1);
        }
    }
}

