/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.validator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.ionite.docval.data.ValidationResult;
import net.ionite.docval.validator.DocumentValidator;
import net.ionite.docval.validator.ValidatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDValidator
implements DocumentValidator {
    private String _filename;
    private InputStream _stream;
    private Validator _validator = null;
    private Logger logger;

    public XSDValidator(String filename) throws ValidatorException {
        this._filename = filename;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.reload();
    }

    public XSDValidator(InputStream stream) throws ValidatorException {
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this._stream = stream;
        this.reload();
    }

    @Override
    public void reload() throws ValidatorException {
        if (this._filename == null && this._validator != null) {
            throw new ValidatorException("Can't reload an XSD validator based on a stream");
        }
        if (this._filename != null) {
            if (this._validator == null) {
                this.logger.info("Loading XSD file {}", (Object)this._filename);
            } else {
                this.logger.info("Reloading XSD file {}", (Object)this._filename);
            }
        } else {
            this.logger.info("Loading XSD validator from stream");
        }
        try {
            StreamSource source;
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (this._filename != null) {
                source = new StreamSource(this._filename);
            } else if (this._stream != null) {
                source = new StreamSource(this._stream);
            } else {
                throw new ValidatorException("Must have either stream or filename to load XSDValidator");
            }
            Schema schema = schemaFactory.newSchema(source);
            this._validator = schema.newValidator();
            this._validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            this._validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXException saxError) {
            this.logger.error("Reloading file {} failed: ", (Object)this._filename, (Object)saxError);
            throw new ValidatorException("Error reading XSD file " + this._filename, saxError);
        }
    }

    @Override
    public ValidationResult validate(byte[] source) throws ValidatorException {
        ValidationResult result = new ValidationResult();
        return this.validate(source, result);
    }

    @Override
    public ValidationResult validate(byte[] source, ValidationResult result) throws ValidatorException {
        try {
            StreamSource ssource = new StreamSource(new ByteArrayInputStream(source));
            this._validator.validate(ssource);
        }
        catch (SAXParseException saxParseError) {
            result.addError(saxParseError.getLocalizedMessage(), null, saxParseError.getLineNumber(), saxParseError.getColumnNumber(), "XML Schema");
        }
        catch (SAXException saxError) {
            result.addError("XML error: " + saxError.toString(), "Unknown", null, null, "XML Schema");
        }
        catch (IOException ioe) {
            this.logger.error("Validation against XSD failed", (Throwable)ioe);
            throw new ValidatorException("Input/output error while validating document", ioe);
        }
        this.logger.debug("Validated document against XSD: {} errors, {} warnings", (Object)result.errorCount(), (Object)result.warningCount());
        return result;
    }
}

