/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.validator;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.ionite.docval.config.ConfigData;
import net.ionite.docval.data.ValidationResult;
import net.ionite.docval.validator.DocumentValidator;
import net.ionite.docval.validator.SCHValidator;
import net.ionite.docval.validator.ValidatorException;
import net.ionite.docval.validator.XSDValidator;
import net.ionite.docval.validator.XSLTValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorManager {
    private HashMap<String, ValidatorManagerEntry> _validators;
    private HashMap<String, ArrayList<String>> _validation_lists;
    private boolean _autoReload = false;
    private ConfigData.UnknownKeywords unknownKeywords = ConfigData.UnknownKeywords.FAIL;
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public ValidatorManager() {
        this._validators = new HashMap();
        this._validation_lists = new HashMap();
    }

    public ValidatorManager(boolean autoReload) {
        this._validators = new HashMap();
        this._validation_lists = new HashMap();
        this._autoReload = autoReload;
    }

    public void setAutoReload(boolean value) {
        this.logger.debug("Autoreload set to {}", (Object)value);
        this._autoReload = value;
    }

    public void setUnknownKeywords(ConfigData.UnknownKeywords unknownKeywords) {
        this.logger.debug("Allow unknown set to {}", (Object)unknownKeywords);
        this.unknownKeywords = unknownKeywords;
    }

    public void applyConfig(ConfigData configData) throws IOException {
        this.setAutoReload(configData.autoReload);
        this.setUnknownKeywords(configData.unknownKeywords);
        for (ConfigData.DocumentType docType : configData.documentTypes) {
            this.logger.info("Loading document type {} with keyword {}", (Object)docType.name, (Object)docType.keyword);
            for (String validationFile : docType.validationFiles) {
                this.logger.info("Adding validation file {} to {}", (Object)validationFile, (Object)docType.name);
                this.addValidator(docType.keyword, validationFile, true);
                if (configData.lazyLoad) {
                    File vf = new File(validationFile);
                    FileReader reader = new FileReader(vf);
                    reader.close();
                    continue;
                }
                this.getValidator(validationFile);
            }
        }
    }

    public DocumentValidator getValidator(String fileName) {
        this.logger.debug("Retrieving validator for {}", (Object)fileName);
        ValidatorManagerEntry entry = this._validators.get(fileName);
        if (entry == null) {
            this.logger.debug("Validator for {} not loaded yet", (Object)fileName);
            entry = new ValidatorManagerEntry(fileName);
            this._validators.put(fileName, entry);
        } else if (this._autoReload) {
            this.logger.debug("Validator for {} loaded, checking whether a reload is necessary", (Object)fileName);
            entry.checkReload();
        }
        return entry.getValidator();
    }

    public void addValidator(String keyword, String fileName, boolean lazyLoad) {
        ArrayList<String> validators = this._validation_lists.get(keyword);
        if (validators == null) {
            validators = new ArrayList();
            this._validation_lists.put(keyword, validators);
        }
        if (!validators.contains(fileName)) {
            validators.add(fileName);
        }
        if (!lazyLoad) {
            this._validators.get(fileName);
        }
    }

    public void addValidator(String keyword, String fileName, DocumentValidator validator) {
        ArrayList<String> validators = this._validation_lists.get(keyword);
        if (validators == null) {
            validators = new ArrayList();
            this._validation_lists.put(keyword, validators);
        }
        if (!validators.contains(fileName)) {
            validators.add(fileName);
        }
        ValidatorManagerEntry entry = new ValidatorManagerEntry(fileName, validator);
        this._validators.put(fileName, entry);
    }

    private ArrayList<String> getValidatorNamesForKeyword(String keyword) {
        ArrayList<String> names = this._validation_lists.get(keyword);
        if (names == null) {
            return new ArrayList<String>();
        }
        return names;
    }

    public ArrayList<DocumentValidator> getValidatorsForKeyword(String keyword) {
        ArrayList<DocumentValidator> result = new ArrayList<DocumentValidator>();
        for (String validatorName : this.getValidatorNamesForKeyword(keyword)) {
            result.add(this.getValidator(validatorName));
        }
        return result;
    }

    public ValidationResult validate(String keyword, byte[] source) {
        ValidationResult result = new ValidationResult();
        ArrayList<String> validatorNames = this.getValidatorNamesForKeyword(keyword);
        if (validatorNames.isEmpty()) {
            this.logger.info("No document type configured with keyword: " + keyword + ", raising exception");
            switch (this.unknownKeywords) {
                case WARN: {
                    result.addWarning("No document type configured with keyword: " + keyword, null, null, null, "Validator selection");
                    break;
                }
                case ERROR: {
                    result.addError("No document type configured with keyword: " + keyword, null, null, null, "Validator selection");
                    break;
                }
                case FAIL: {
                    throw new ValidatorException("No document type configured with keyword: " + keyword);
                }
            }
        } else {
            for (String validatorName : validatorNames) {
                this.getValidator(validatorName).validate(source, result);
            }
        }
        return result;
    }

    private class ValidatorManagerEntry {
        private long _lastModified;
        private String _fileName;
        private DocumentValidator _validator;

        public ValidatorManagerEntry(String fileName) {
            this._fileName = fileName;
            this.loadValidator();
        }

        public ValidatorManagerEntry(String name, DocumentValidator validator) {
            this._fileName = name;
            this._validator = validator;
        }

        public DocumentValidator getValidator() {
            return this._validator;
        }

        public void loadValidator() {
            this._lastModified = new File(this._fileName).lastModified();
            if (this._fileName.endsWith(".xsd")) {
                this._validator = new XSDValidator(this._fileName);
            } else if (this._fileName.endsWith(".xslt") || this._fileName.endsWith(".xsl")) {
                this._validator = new XSLTValidator(this._fileName);
            } else if (this._fileName.endsWith(".sch")) {
                this._validator = new SCHValidator(this._fileName);
            } else {
                throw new ValidatorException("Unsupported validator file extension, must be .xsd, .xsl, or .xslt: " + this._fileName);
            }
        }

        public void checkReload() {
            long lastModified = new File(this._fileName).lastModified();
            if (lastModified > this._lastModified) {
                this.loadValidator();
            }
        }
    }
}

