/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.IOException;
import net.ionite.docval.config.ConfigData;
import net.ionite.docval.config.ConfigReader;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.server.DocValHttpServer;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class DocValHttpServerMain {
    private Namespace args;
    private ArgumentParser parser;

    public int run(String[] argv) {
        this.parser = ArgumentParsers.newFor((String)"ion-docval-server").addHelp(true).build().description("Validate a document given any number of XSD or Schematron XSLT files");
        this.parser.addArgument(new String[]{"-c", "--config"}).help("Use configuration file with schema/schematron definitions");
        this.parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeConst()).setConst((Object)true).setDefault((Object)false).help("Print verbose debug output");
        try {
            this.args = this.parser.parseArgs(argv);
            if (((Boolean)this.args.get("verbose")).booleanValue()) {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
            } else {
                System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
            }
            try {
                String configFile = (String)this.args.get("config");
                ConfigReader configReader = configFile == null ? new ConfigReader(System.getProperty("app.home") + "/default_config.xml") : new ConfigReader(configFile);
                try {
                    ConfigData configData = configReader.readConfig();
                    DocValHttpServer server = new DocValHttpServer(configData);
                    if (configData.server == null || configData.server.listen == null || configData.server.listen.size() == 0) {
                        System.err.println("No Server or Listen section in provided configuration file " + configFile);
                        return -1;
                    }
                    for (ConfigData.Listen listen : configData.server.listen) {
                        server.addListener(listen.address, listen.port);
                    }
                    server.start();
                    Thread.currentThread().join();
                    return 0;
                }
                catch (ConfigurationError configError) {
                    System.out.println(configError.getMessage());
                    return -2;
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                    return -3;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return 1;
            }
        }
        catch (ArgumentParserException e1) {
            e1.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] argv) {
        DocValHttpServerMain mainInstance = new DocValHttpServerMain();
        System.exit(mainInstance.run(argv));
    }
}

