/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.validator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.ionite.docval.validator.ValidatorException;
import net.ionite.docval.validator.XSLTValidator;
import net.ionite.docval.xml.IgnoreErrorHandler;

public class SCHValidator
extends XSLTValidator {
    public SCHValidator(String filename) {
        super(filename);
    }

    public SCHValidator(InputStream stream) {
        super(stream);
    }

    @Override
    protected Transformer setupTransformer() {
        try {
            this.logger.debug("Starting Schematron to SVRL Stylesheet conversion");
            SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            stf.setURIResolver(new BasicURIResolver(this._filename));
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.logger.debug("Loading dsdl include stylesheet");
            Templates templates1 = stf.newTemplates(new StreamSource(classLoader.getResourceAsStream("xsl/iso_dsdl_include.xsl")));
            this.logger.debug("Loading abstract-expand stylesheet");
            Templates templates2 = stf.newTemplates(new StreamSource(classLoader.getResourceAsStream("xsl/iso_abstract_expand.xsl")));
            this.logger.debug("Loading svrl-for-xslt2 stylesheet");
            Templates templates3 = stf.newTemplates(new StreamSource(classLoader.getResourceAsStream("xsl/iso_svrl_for_xslt2.xsl")));
            TransformerHandler th1 = stf.newTransformerHandler(templates1);
            TransformerHandler th2 = stf.newTransformerHandler(templates2);
            TransformerHandler th3 = stf.newTransformerHandler(templates3);
            th1.setResult(new SAXResult(th2));
            th2.setResult(new SAXResult(th3));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult last = new StreamResult(outputStream);
            th3.setResult(last);
            this.logger.debug("Transforming sch file");
            Transformer t = stf.newTransformer();
            t.setErrorListener(new IgnoreErrorHandler());
            t.transform(new StreamSource(new File(this._filename)), new SAXResult(th1));
            this.logger.debug("Finished Schematron to SVRL Stylesheet conversion");
            return this.loadTransformer(new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (Exception error) {
            throw new ValidatorException("Error setting up SCH validator for " + this._filename, error);
        }
    }

    private static class BasicURIResolver
    implements URIResolver {
        private String originalPath;

        public BasicURIResolver(String baseFileName) {
            this.originalPath = new File(baseFileName).getParent() + "/";
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if (href.equals("iso_schematron_skeleton_for_saxon.xsl")) {
                String url = "xsl/" + href;
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream is = classLoader.getResourceAsStream(url);
                return new StreamSource(is);
            }
            if (href.startsWith("/")) {
                return new StreamSource(new File(href));
            }
            return new StreamSource(new File(this.originalPath + href));
        }
    }
}

