/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import net.ionite.docval.config.ConfigData;
import net.ionite.docval.config.ConfigReader;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.server.ContentType;
import net.ionite.docval.validator.ValidatorException;
import net.ionite.docval.validator.ValidatorManager;
import net.ionite.docval.xml.KeywordDeriver;
import net.sf.saxon.s9api.SaxonApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocValHttpServer
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private ValidatorManager validatorManager;
    private ArrayList<HttpServer> listeners = new ArrayList();
    private String configFile = null;
    private ConfigData configData = null;

    private void respondToRequest(HttpExchange t, String responseContent, int statusCode) throws IOException {
        byte[] responseBytes = responseContent.getBytes();
        t.sendResponseHeaders(statusCode, responseBytes.length);
        OutputStream os = t.getResponseBody();
        os.write(responseBytes);
        os.close();
    }

    public DocValHttpServer(String configFile) throws IOException, ConfigurationError {
        this.configFile = configFile;
        this.setValidatorManager(new ValidatorManager());
        this.loadConfigFile();
        if (this.configData.server == null || this.configData.server.listen == null || this.configData.server.listen.size() == 0) {
            throw new ConfigurationError("No Server or Listen section in provided configuration file " + configFile);
        }
        for (ConfigData.Listen listen : this.configData.server.listen) {
            this.addListener(listen.address, listen.port);
        }
        this.setValidatorManager(this.validatorManager);
    }

    public DocValHttpServer(ConfigData configData) throws IOException, ConfigurationError {
        this.configData = configData;
        ValidatorManager validatorManager = new ValidatorManager();
        validatorManager.applyConfig(configData);
        this.setValidatorManager(validatorManager);
    }

    public DocValHttpServer(ValidatorManager validatorManager) {
        this.setValidatorManager(validatorManager);
    }

    public void loadConfigFile() throws IOException, ConfigurationError {
        if (this.configFile != null) {
            ConfigReader configReader = new ConfigReader(this.configFile);
            ConfigData newConfigData = configReader.readConfig();
            this.validatorManager.applyConfig(newConfigData);
            this.configData = newConfigData;
        }
    }

    public void setValidatorManager(ValidatorManager validatorManager) {
        this.validatorManager = validatorManager;
    }

    public void addListener(String host, int port) throws IOException {
        this.logger.info("ion-docval HTTP server binding to " + host + " port " + port);
        HttpServer listener = HttpServer.create(new InetSocketAddress(host, port), 100);
        listener.createContext("/validate", new IndexHandler());
        listener.createContext("/api/validate", new ValidatorHandler(this.validatorManager));
        if (this.configData != null) {
            listener.createContext("/api/document_types", new DocumentTypesHandler(this.configData));
        }
        listener.setExecutor(null);
        this.listeners.add(listener);
    }

    @Override
    public void start() {
        for (HttpServer listener : this.listeners) {
            listener.start();
            this.logger.info("ion-docval-server listening on " + listener.getAddress().getHostName() + " port " + listener.getAddress().getPort());
        }
    }

    public void halt(int delay) {
        this.logger.info("ion-docval-server shutting down");
        for (HttpServer listener : this.listeners) {
            listener.stop(delay);
        }
    }

    class ValidatorHandler
    implements HttpHandler {
        private Logger logger;
        private ValidatorManager validatorManager;

        public ValidatorHandler(ValidatorManager validatorManager) {
            this.validatorManager = validatorManager;
            this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        }

        private HashMap<String, String> readRequestParameters(HttpExchange t) {
            HashMap<String, String> result = new HashMap<String, String>();
            String queryString = t.getRequestURI().getQuery();
            if (queryString == null) {
                return result;
            }
            int last = 0;
            int l = queryString.length();
            while (last < l) {
                int next = queryString.indexOf(38, last);
                if (next == -1) {
                    next = l;
                }
                if (next > last) {
                    int eqPos = queryString.indexOf(61, last);
                    try {
                        if (eqPos < 0 || eqPos > next) {
                            result.put(URLDecoder.decode(queryString.substring(last, next), "utf-8"), "");
                        } else {
                            result.put(URLDecoder.decode(queryString.substring(last, eqPos), "utf-8"), URLDecoder.decode(queryString.substring(eqPos + 1, next), "utf-8"));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ValidatorException("Unable to decode URL string", e);
                    }
                }
                last = next + 1;
            }
            return result;
        }

        private byte[] readRequestBody(HttpExchange t) throws IOException {
            InputStream is = t.getRequestBody();
            byte[] inBuffer = new byte[8192];
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            int readBytes = 0;
            while ((readBytes = is.read(inBuffer, 0, inBuffer.length)) != -1) {
                outBuffer.write(inBuffer, 0, readBytes);
            }
            return outBuffer.toByteArray();
        }

        private void POST(HttpExchange t) throws IOException {
            ContentType responseContentType;
            byte[] inputData;
            Headers requestHeaders = t.getRequestHeaders();
            Headers responseHeaders = t.getResponseHeaders();
            int contentLength = Integer.parseInt(requestHeaders.getFirst("Content-length"));
            String contentType = requestHeaders.getFirst("Content-Type");
            if (contentType.startsWith("application/xml") || contentType.startsWith("text/xml")) {
                inputData = this.readRequestBody(t);
                if (inputData.length != contentLength) {
                    throw new IOException("Data in HTTP POST body differs from length of Content-Length header");
                }
            } else {
                DocValHttpServer.this.respondToRequest(t, "\"Unsupported Content-Type: '" + contentType + "' \"", 415);
                return;
            }
            String accept = requestHeaders.getFirst("Accept");
            int statusCode = 200;
            String responseData = "";
            if (accept.equals("application/xml") || accept.equals("text/xml")) {
                responseHeaders.set("Content-Type", accept);
                responseContentType = ContentType.XML;
            } else if (accept.equals("application/json") || accept.equals("*/*")) {
                responseHeaders.set("Content-Type", "application/json");
                responseContentType = ContentType.JSON;
            } else {
                DocValHttpServer.this.respondToRequest(t, "\"Could not satisfy the request Accept header '" + accept + "' \"", 406);
                return;
            }
            String keyword = this.readRequestParameters(t).getOrDefault("keyword", null);
            try {
                if (keyword == null) {
                    KeywordDeriver kwd = new KeywordDeriver();
                    keyword = kwd.deriveKeyword(inputData);
                }
                switch (responseContentType) {
                    case XML: {
                        try {
                            responseData = this.validatorManager.validate(keyword, inputData).toXMLString();
                        }
                        catch (SaxonApiException saxError) {
                            this.logger.error("Unable to convert validation results to XML", (Throwable)saxError);
                            responseData = "<Error><Detail>Unable to convert validation results to XML</Detail></Error>";
                        }
                        break;
                    }
                    case JSON: {
                        responseData = this.validatorManager.validate(keyword, inputData).toJSONString();
                    }
                }
                statusCode = 200;
            }
            catch (ValidatorException valError) {
                this.logger.error("Error processing request: " + valError.getMessage(), (Throwable)valError);
                responseData = "Error: " + valError.getMessage();
                statusCode = 400;
            }
            DocValHttpServer.this.respondToRequest(t, responseData, statusCode);
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            this.logger.debug("ValidatorHandler.handle() called");
            try {
                String method = t.getRequestMethod();
                this.logger.debug("Request method: " + method);
                if ("POST".equals(method)) {
                    this.POST(t);
                } else {
                    DocValHttpServer.this.respondToRequest(t, "\"Method " + method + " not allowed", 405);
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while handling client request", (Throwable)e);
                throw e;
            }
        }
    }

    class DocumentTypesHandler
    implements HttpHandler {
        private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        private ConfigData configData;

        public DocumentTypesHandler(ConfigData configData) {
            this.configData = configData;
        }

        private void GET(HttpExchange t) throws IOException {
            Headers requestHeaders = t.getRequestHeaders();
            Headers responseHeaders = t.getResponseHeaders();
            String accept = requestHeaders.getFirst("Accept");
            int statusCode = 200;
            String responseData = "";
            if (accept.equals("application/xml") || accept.equals("text/xml")) {
                responseHeaders.set("Content-Type", accept);
                try {
                    responseData = this.configData.documentTypesAsXMLString();
                }
                catch (SaxonApiException e) {
                    this.logger.error("Unable to convert document types to XML", (Throwable)e);
                    responseData = "<Error><Detail>Unable to convert document types to XML</Detail></Error>";
                    statusCode = 500;
                }
            } else if (accept.equals("application/json") || accept.equals("*/*")) {
                responseHeaders.set("Content-Type", "application/json");
                responseData = this.configData.documentTypesAsJSONString();
            } else {
                DocValHttpServer.this.respondToRequest(t, "\"Could not satisfy the request Accept header '" + accept + "' \"", 406);
                return;
            }
            DocValHttpServer.this.respondToRequest(t, responseData, statusCode);
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            this.logger.debug("DocumentTypesHandler.handle() called");
            try {
                String method = t.getRequestMethod();
                this.logger.debug("Request method: " + method);
                if ("GET".equals(method)) {
                    this.GET(t);
                } else {
                    DocValHttpServer.this.respondToRequest(t, "\"Method " + method + " not allowed", 405);
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while handling client request", (Throwable)e);
                throw e;
            }
        }
    }

    class IndexHandler
    implements HttpHandler {
        private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

        private byte[] readLocalFileData(String localPath) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream is = classLoader.getResourceAsStream(localPath);
                return is.readAllBytes();
            }
            catch (IOException ioe) {
                return "Error reading template".getBytes();
            }
        }

        private void GET(HttpExchange t) throws IOException {
            this.logger.debug("received GET request");
            byte[] formData = this.readLocalFileData("html/index.html");
            this.logger.debug("read standard response data (", (Object)formData.length, (Object)"bytes )");
            t.sendResponseHeaders(200, formData.length);
            OutputStream os = t.getResponseBody();
            os.write(formData);
            os.close();
            this.logger.debug("GET response data sent to client");
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            this.logger.debug("IndexHandler.handle() called");
            try {
                String method = t.getRequestMethod();
                this.logger.debug("Request method: " + method);
                if ("GET".equals(method)) {
                    this.GET(t);
                } else {
                    DocValHttpServer.this.respondToRequest(t, "\"Method " + method + " not allowed", 405);
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while handling client request", (Throwable)e);
                throw e;
            }
        }
    }
}

