/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import net.ionite.docval.data.ValidationResult;
import net.ionite.docval.server.DocValClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private String uri = "http://localhost:35791/api/validate";
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public Client() {
    }

    public Client(String uri) {
        this.uri = uri;
    }

    public ValidationResult validate(byte[] documentData) throws DocValClientException {
        return this.validate(documentData, null);
    }

    public ValidationResult validate(byte[] documentData, String keyword) throws DocValClientException {
        try {
            if (keyword == null) {
                this.logger.debug("Sending document of " + documentData.length + " bytes to server at " + this.uri + ", derive keyword");
            } else {
                this.logger.debug("Sending document of " + documentData.length + " bytes to server at " + this.uri + " with keyword " + keyword);
            }
            if (keyword != null) {
                this.uri = this.uri + "?keyword=" + URLEncoder.encode(keyword, StandardCharsets.UTF_8.toString());
            }
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(this.uri)).header("Accept", "application/json").header("Content-Type", "application/xml").POST(HttpRequest.BodyPublishers.ofByteArray(documentData)).build();
            HttpResponse<String> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
            this.logger.debug("Status code from " + this.uri + ": " + response.statusCode());
            return ValidationResult.fromJSONString(response.body());
        }
        catch (URISyntaxException e) {
            throw new DocValClientException("Malformed URI: " + this.uri, e);
        }
        catch (IOException e) {
            throw new DocValClientException("Error communicating with server at: " + this.uri, e);
        }
        catch (InterruptedException e) {
            throw new DocValClientException("Client request interrupted", e);
        }
    }
}

