/*
 * Decompiled with CFR 0.152.
 */
package net.ionite.docval.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.ionite.docval.config.ConfigData;
import net.ionite.docval.config.ConfigurationError;
import net.ionite.docval.data.ValidationResult;
import net.ionite.docval.data.ValidationResultItem;
import net.ionite.docval.validator.XSDValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigReader {
    private String _fileName;
    ConfigData config;
    private Logger logger = LoggerFactory.getLogger(ConfigReader.class);

    public ConfigReader(String fileName) {
        this.logger.info("Reading configuration from file " + fileName);
        this._fileName = fileName;
        this.config = new ConfigData();
        this.config.documentTypes.add(this.config.new ConfigData.DocumentType());
    }

    public ConfigData readConfig() throws ConfigurationError {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            XSDValidator configXMLValidator = new XSDValidator(classLoader.getResourceAsStream("xsd/ion-docval-config.xsd"));
            ValidationResult vr = configXMLValidator.validate(Files.readAllBytes(Paths.get(this._fileName, new String[0])));
            for (ValidationResultItem validationResultItem : vr.getWarnings()) {
                System.err.println("Warning: " + validationResultItem.message);
            }
            if (vr.errorCount() > 0) {
                String errorMessage = "";
                for (ValidationResultItem item : vr.getErrors()) {
                    if (!errorMessage.equals("")) {
                        errorMessage = errorMessage + ", ";
                    }
                    errorMessage = errorMessage + item.message;
                }
                throw new ConfigurationError("Error in configuration file " + this._fileName + ": " + errorMessage);
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser sAXParser = factory.newSAXParser();
            ConfigFileXMLHandler configXMLHandler = new ConfigFileXMLHandler();
            sAXParser.parse(this._fileName, (DefaultHandler)configXMLHandler);
            return configXMLHandler.configData;
        }
        catch (IOException ioError) {
            throw new ConfigurationError("Error while reading configuration file: " + ioError.toString(), ioError);
        }
        catch (ParserConfigurationException parserError) {
            throw new ConfigurationError("Error while reading configuration file" + this._fileName + ": " + parserError.getMessage(), parserError);
        }
        catch (SAXException saxException) {
            throw new ConfigurationError("Error while reading configuration file" + this._fileName + ": " + saxException.getMessage(), saxException);
        }
    }

    private class ConfigFileXMLHandler
    extends DefaultHandler {
        public ConfigData configData = new ConfigData();
        private StringBuilder _currentValue = new StringBuilder();
        private ConfigData.DocumentType _currentDocumentType;
        private String _currentAddress = null;
        private int _currentPort = 0;

        private ConfigFileXMLHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this._currentValue.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this._currentValue.setLength(0);
            switch (qName) {
                case "Server": {
                    this.configData.server = this.configData.new ConfigData.Server();
                    break;
                }
                case "DocumentType": {
                    this._currentDocumentType = this.configData.new ConfigData.DocumentType();
                    break;
                }
                case "Keyword": {
                    break;
                }
                case "ValidationFile": {
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (qName) {
                case "AutoReload": {
                    this.configData.autoReload = Boolean.parseBoolean(this._currentValue.toString());
                    break;
                }
                case "UnknownKeywords": {
                    switch (this._currentValue.toString().toLowerCase()) {
                        case "warn": {
                            this.configData.unknownKeywords = ConfigData.UnknownKeywords.WARN;
                            break;
                        }
                        case "error": {
                            this.configData.unknownKeywords = ConfigData.UnknownKeywords.ERROR;
                            break;
                        }
                        case "fail": {
                            this.configData.unknownKeywords = ConfigData.UnknownKeywords.FAIL;
                            break;
                        }
                        case "ignore": {
                            this.configData.unknownKeywords = ConfigData.UnknownKeywords.IGNORE;
                        }
                    }
                    break;
                }
                case "LazyLoad": {
                    this.configData.lazyLoad = Boolean.parseBoolean(this._currentValue.toString());
                    break;
                }
                case "Server": {
                    break;
                }
                case "Listen": {
                    ArrayList<ConfigData.Listen> arrayList = this.configData.server.listen;
                    ConfigData configData = this.configData;
                    Objects.requireNonNull(configData);
                    arrayList.add(configData.new ConfigData.Listen(this._currentAddress, this._currentPort));
                    break;
                }
                case "Address": {
                    this._currentAddress = this._currentValue.toString();
                    break;
                }
                case "Port": {
                    this._currentPort = Integer.parseInt(this._currentValue.toString());
                    break;
                }
                case "DocumentType": {
                    this.configData.documentTypes.add(this._currentDocumentType);
                    break;
                }
                case "Name": {
                    this._currentDocumentType.name = this._currentValue.toString();
                    break;
                }
                case "Description": {
                    this._currentDocumentType.description = this._currentValue.toString();
                    break;
                }
                case "Keyword": {
                    this._currentDocumentType.keyword = this._currentValue.toString();
                    break;
                }
                case "ValidationFile": {
                    this._currentDocumentType.validationFiles.add(this._currentValue.toString());
                }
            }
        }
    }
}

